/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
 package cnrg.itx.datax;

import java.util.Vector;

/**
 * Class to implement the properties of a connection. This will contain the properties
 * of all the channels that make up the connection.
 */
public class ConnectionProperty
{
	/**
	 * The channel properties for this connection.
	 */
	private ChannelProperty inputChannelProperties;
	private ChannelProperty outputChannelProperties;
	
	/**
	 * Default constructor for the ConnectionProperties object.
	 */
	public ConnectionProperty ()
	{
		// Do nothing
	}
	
	/**
	 * Method to add a channel property.
	 * @param channelProperty the property of a channel to add
	 */
	public void addChannelProperty (ChannelProperty channelProperty)
	{
		if (channelProperty.getChannelType () == Channel.INPUT)
			inputChannelProperties = channelProperty;
		else if (channelProperty.getChannelType () == Channel.OUTPUT)
			outputChannelProperties = channelProperty;
	}
	
	/**
	 * Method to get the input channel's properties
	 * @return ChannelProperties the input channel's properties
	 */
	
	/**
	 * Method to find the optimal properties for two connection properties.
	 * @param peer the peer's connection properties
	 * @return ConnectionProperties the optimal connection properties
	 */
	public ConnectionProperty getOptimalConnectionProperties (ConnectionProperty peerConnectionProperties)
	{
		//ChannelProperty inputChannelProperties = this.ge
		return null;
	}
}